#ifndef ZMODELER_STRUCT_NORMVERT_H_INCLUDED
#define ZMODELER_STRUCT_NORMVERT_H_INCLUDED

/********************************************
      Editor's Vertices
********************************************/
#include "..\Common\ZMMatrix.h"
class DllExport tNormalVertex: public tVertex
{
public:
//----------------------
//  data members
  float  NormalX,
      NormalY,
      NormalZ;

//----------------------
//  construction

  tNormalVertex();
  tNormalVertex(tPOINT V, tPOINT N);
  tNormalVertex(  float _vx,float _vy, float _vz,
          float _nx,float _ny, float _nz);
  tNormalVertex(tPOINT V, tPOINT N, DWORD col);
  tNormalVertex(  float _vx,float _vy, float _vz,
          float _nx,float _ny, float _nz,
          DWORD col);

//----------------------
//  functions
  void  ResetNormal();    //resets normal components to 0.0f
  void  NormalizeNormal();  //normalizes normals to 1.0f length
  // adds components to current normal components.
  void  CalculateNormal(float newx, float newy, float newz); 

  // inits vertex with supplied coordinates
  void MakeVertex(tPOINT src,
          tPOINT srcnorm);
  // inits vertex with supplied coordinates
  void MakeVertex(tPOINT src,
          tPOINT srcnorm,
          DWORD  col);

  // draws the vertex on supplied CDC object
  virtual void Draw(  CDC* pDC,
            z3dViewDescriptor* pView,
            BOOL DrawMarked,
            BOOL DrawExtraSize);

  // returns TRUE if Mark-state of the vertex has changed by supplied loc
  virtual BOOL Cover(  POINT *loc,
            z3dViewDescriptor* pView,
            long CoverRadius);
  // returns TRUE is the vertex is in supplied bounding box (3D)
  BOOL InRectRegion(  tPOINT *min,
            tPOINT *max,
            BOOL CrossEnough);
  // returns TRUE is the vertex is in supplied elliptic volume (3D)
  BOOL InCircRegion(  tPOINT *center,
            float *xRadius,
            float *yRadius,
            float *zRadius,
            BOOL CrossEnough);
  //////////////////////////////////////////////////
  //  Operator Redefinition
  // rotates marked or selected vertices to supplied angle in supplied view
  void   Rotate(
            z3dViewDescriptor* pView,
            float Angle,
            BOOL MarkedMode, BOOL Selection,
            tPOINT& axis, tPOINT& base);
  // rotates normals of marked or selected vertices to supplied angle in supplied view
  void RotateNormal(
            z3dViewDescriptor* pView,
            float Angle,
            BOOL MarkedMode, BOOL Selection,
            tPOINT& axis, tPOINT& base);
  //---------------------------------------------------------------
  // mirrors the vertex (and normal) around global AXIS center.
  void  Mirror(BOOL bX, BOOL bY, BOOL bZ, BOOL MarkedMode, BOOL Selection);
  //---------------------------------------------------------------
  // Changes normals direction if vertex is either marked or selected.
  // it can flip any axis (component) x,y,z or all of them at a time
  //---------------------------------------------------------------
  void  FlipNormal(BOOL FlipX, BOOL FlipY, BOOL FlipZ);
//----------------------------
//  operators
  tNormalVertex& operator= (const tNormalVertex& v);
  operator==(const tNormalVertex& v);
  operator!=(const tNormalVertex& v);

};

#endif

